# 機能設計書 4-next export

## 概要

本ドキュメントは、Next.jsの静的HTMLエクスポートコマンド `next export` の機能設計を記述する。このコマンドは現在のバージョンでは廃止されており、`next.config.js` の `output: 'export'` 設定に置き換えられている。

### 本機能の処理概要

`next export` コマンドは、かつてアプリケーションを静的HTMLファイルとして書き出すために使用されたCLIコマンドであるが、現行バージョンでは削除済みである。実行するとエラーメッセージを表示して終了する。

**業務上の目的・背景**：静的サイト出力の需要は依然として存在するが、`next export` コマンドは `next.config.js` の `output: 'export'` 設定と `next build` の組み合わせに統合された。この変更によりビルドプロセスの一貫性が向上し、設定による静的エクスポートの制御が容易になった。

**機能の利用シーン**：旧バージョンからのマイグレーション時に `next export` を実行した場合に、移行先の設定方法を案内するために残されている。

**主要な処理内容**：
1. 廃止メッセージの表示（`output: 'export'` への移行案内）
2. ドキュメントリンクの提示
3. プロセスの終了（exit code: 1）

**関連システム・外部連携**：なし

**権限による制御**：なし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 関連画面なし（CLIエラーメッセージのみ） |

## 機能種別

CLIコマンド / 廃止済み機能 / マイグレーション支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | パラメータは受け付けない | - |

### 入力データソース

なし。コマンド実行のみ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| エラーメッセージ | string | 廃止メッセージと移行先の案内 |

### 出力先

- 標準エラー出力（廃止メッセージ）

## 処理フロー

### 処理シーケンス

```
1. エラーメッセージ出力
   └─ `next export` has been removed in favor of 'output: export' in next.config.js.
   └─ ドキュメントURL: https://nextjs.org/docs/app/building-your-application/deploying/static-exports
2. プロセス終了
   └─ exit code: 1
```

### フローチャート

```mermaid
flowchart TD
    A[next export 実行] --> B[廃止メッセージ表示]
    B --> C[process.exit 1]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 常にエラー終了 | 引数やオプションにかかわらず常にエラーメッセージを表示して終了する | 常時 |
| BR-02 | 隠しコマンド | CLIヘルプには表示されない（`hidden: true`） | 常時 |

### 計算ロジック

なし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを操作しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit code 1 | 廃止コマンド | コマンド実行時（常時） | next.config.jsに`output: 'export'`を設定し、`next build`を使用 |

### リトライ仕様

なし（常にエラー終了）。

## トランザクション仕様

なし。

## パフォーマンス要件

なし（即座に終了する）。

## セキュリティ考慮事項

なし。

## 備考

- 本コマンドはCLIの`hidden: true`オプションで登録されており、`next --help`には表示されない
- 静的エクスポート機能自体は `output: 'export'` 設定と `next build` で引き続き利用可能
- 移行ドキュメント: https://nextjs.org/docs/app/building-your-application/deploying/static-exports

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

本機能は非常にシンプルで、1ファイル15行で完結する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | next.ts | `packages/next/src/bin/next.ts` | exportコマンドの登録（344-347行目）。`hidden: true`で隠しコマンドとして登録 |
| 1-2 | next-export.ts | `packages/next/src/cli/next-export.ts` | nextExport関数（4-12行目）。エラーメッセージ表示とprocess.exit(1) |

**主要処理フロー**:
1. **344-347行目（next.ts）**: `program.command('export', { hidden: true })`で隠しコマンドとして登録。helpOptionはfalse
2. **4-11行目（next-export.ts）**: `error()`でメッセージ出力。`cyan()`でURLをハイライト
3. **11行目**: `process.exit(1)`で終了

**読解のコツ**: `picocolors`ライブラリの`cyan`関数はターミナルでURLをシアン色で表示するために使用されている。`error`は`../build/output/log`からインポートされるログ関数。

### プログラム呼び出し階層図

```
bin/next.ts (CLIエントリーポイント)
    │
    └─ cli/next-export.ts::nextExport()
           ├─ build/output/log.ts::error() [メッセージ出力]
           └─ process.exit(1)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

CLI実行 ─────────────▶ nextExport() ────────────────▶ エラーメッセージ (stderr)
                                                      ▶ exit code: 1
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| next.ts | `packages/next/src/bin/next.ts` | ソース | CLIメインエントリーポイント |
| next-export.ts | `packages/next/src/cli/next-export.ts` | ソース | next exportコマンドの実装（廃止メッセージ表示） |
| log.ts | `packages/next/src/build/output/log.ts` | ソース | ログ出力ユーティリティ |
| picocolors.ts | `packages/next/src/lib/picocolors.ts` | ソース | ターミナルカラー出力ユーティリティ |
